<?php
    global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Panel_Flip'))) {
		class WPBakeryShortCode_TS_VCSC_Panel_Flip extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                      => __( "TS Panel Flip", "ts_visual_composer_extend" ),
		"base"                      => "TS_VCSC_Panel_Flip",
		"icon" 	                    => "ts-composer-element-icon-content-flip",
		"category"                  => __( "Composium", "ts_visual_composer_extend" ),
		"description"               => __("Place a panel flip element", "ts_visual_composer_extend"),
		"admin_enqueue_js"			=> "",
		"admin_enqueue_css"			=> "",
		"params"                    => array(
			// Main Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_1_1",
				"seperator"			=> "Flip Effect",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Style", "ts_visual_composer_extend" ),
				"param_name"        => "flip_style",
				"width"             => 300,
				"value"             => array(
					__( 'Standard', "ts_visual_composer_extend" )     			=> "style1",
					__( 'Cube', "ts_visual_composer_extend" )         			=> "style2",
				),
				"admin_label"       => true,
				"description"       => __( "Select the type of flip box element.", "ts_visual_composer_extend" )
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Effect Style", "ts_visual_composer_extend" ),
				"param_name"        => "flip_effect_style1",
				"width"             => 300,
				"value"             => array(
					__( 'Horizontal Flip Right', "ts_visual_composer_extend" )	=> "horizontal flip-container-ltr",
					__( 'Horizontal Flip Left', "ts_visual_composer_extend" )	=> "horizontal flip-container-rtl",
					__( 'Vertical Flip Up', "ts_visual_composer_extend" )     	=> "vertical flip-container-up",
					__( 'Vertical Flip Down', "ts_visual_composer_extend" )		=> "vertical flip-container-down",
				),
				"description"       => __( "Select the type of flip effect.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_style", 'value' => 'style1' )
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Effect Style", "ts_visual_composer_extend" ),
				"param_name"        => "flip_effect_style2",
				"width"             => 300,
				"value"             => array(
					__( 'Horizontal Flip Right', "ts_visual_composer_extend" )	=> "ts-flip-right",
					__( 'Horizontal Flip Left', "ts_visual_composer_extend" )	=> "ts-flip-left",
					__( 'Vertical Flip Up', "ts_visual_composer_extend" )		=> "ts-flip-up",
					__( 'Vertical Flip Down', "ts_visual_composer_extend" )		=> "ts-flip-down",
				),
				"description"       => __( "Select the type of flip effect.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_style", 'value' => 'style2' )
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Effect Speed", "ts_visual_composer_extend" ),
				"param_name"        => "flip_effect_speed",
				"width"             => 300,
				"value"             => array(					
					__( 'Very Slow', "ts_visual_composer_extend" )    			=> "veryslow",
					__( 'Slow', "ts_visual_composer_extend" )         			=> "slow",
					__( 'Medium', "ts_visual_composer_extend" )       			=> "medium",
					__( 'Fast', "ts_visual_composer_extend" )         			=> "fast",
					__( 'Very Fast', "ts_visual_composer_extend" )    			=> "veryfast",
				),
				"default"			=> "medium",
				"standard"			=> "medium",
				"std"				=> "medium",
				"admin_label"       => true,
				"description"       => __( "Select the speed for the flip effect.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Trigger", "ts_visual_composer_extend" ),
				"param_name"        => "flip_effect_trigger",
				"width"             => 300,
				"value"             => array(
					__( 'Hover', "ts_visual_composer_extend" )       			=> "hover",
					__( 'Click', "ts_visual_composer_extend" )    				=> "click",
				),
				"description"       => __( "Select how the flip effect should be triggered; mobile devices will always revert to a tap event.", "ts_visual_composer_extend" ),
			),			
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Show Flip Handle", "ts_visual_composer_extend" ),
				"param_name"		=> "flip_handle_show",
				"value"				=> "false",
				"description"		=> __( "Use the toggle to show or hide a flip handle indicator below the flip element.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",	
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Handle Color", "ts_visual_composer_extend" ),
				"param_name"		=> "flip_handle_color",
				"value"				=> "#0094FF",
				"description"		=> __( "Define the color for the flip handle button.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",	
				"dependency"		=> array( 'element' => "flip_handle_show", 'value' => 'true' ),
			),			
			array(
				"type"             	=> "switch_button",
				"heading"           => __( "Auto-Size Flip Box Height", "ts_visual_composer_extend" ),
				"param_name"        => "flip_size_auto",
				"value"             => "true",
				"admin_label"       => true,
				"description"       => __( "Switch the toggle if you want to auto-size the height of the content flip box.", "ts_visual_composer_extend" ),
			),				
			array(
				"type"              => "dropdown",
				"heading"           => __( "Flip Box Size", "ts_visual_composer_extend" ),
				"param_name"        => "flip_size_type",
				"width"             => 300,
				"value"             => array(
					__( 'Fixed Height', "ts_visual_composer_extend" )       			=> "fixed",
					__( 'Minimum Height', "ts_visual_composer_extend" )    				=> "minimum",
					__( 'Maximum Height', "ts_visual_composer_extend" )					=> "maximum",
				),
				"description"       => __( "Select the speed for the flip effect.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_size_auto", 'value' => 'false' )
			),				
			array(
				"type"              => "nouislider",
				"heading"           => __( "Fixed Height", "ts_visual_composer_extend" ),
				"param_name"        => "flip_size",
				"value"             => "100",
				"min"               => "200",
				"max"               => "800",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the fixed height for the content flip element.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_size_type", 'value' => 'fixed' )
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Minimum Height", "ts_visual_composer_extend" ),
				"param_name"        => "flip_size_min",
				"value"             => "100",
				"min"               => "200",
				"max"               => "800",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the minimum height for the content flip element.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_size_type", 'value' => 'minimum' )
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Maximum Height", "ts_visual_composer_extend" ),
				"param_name"        => "flip_size_max",
				"value"             => "100",
				"min"               => "200",
				"max"               => "800",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the maximum height for the content flip element.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "flip_size_type", 'value' => 'maximum' )
			),
			// Front Banner Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2_1",
				"seperator"			=> "Front Banner",
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Front Panel: Use Banner", "ts_visual_composer_extend" ),
				"param_name"		=> "front_banner_use",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to add a banner image to the top of the front panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "attach_image",
				"heading"           => __( "Front Panel: Banner Image", "ts_visual_composer_extend" ),
				"param_name"        => "front_banner_image",
				"value"             => "",
				"description"       => __( "Select the image to be used as banner for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_banner_use", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			// Front Icon/Image Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2_2",
				"seperator"			=> "Front Icon",
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Front Panel: Icon Type", "ts_visual_composer_extend" ),
				"param_name"        => "front_icon_type",
				"width"             => 300,
				"value"             => array(
					__( 'None', "ts_visual_composer_extend" )       					=> "none",
					__( 'Font Icon', "ts_visual_composer_extend" )       				=> "icon",
					__( 'Image Icon', "ts_visual_composer_extend" )    					=> "image",
				),
				"description"       => __( "Select the type of icon or image you want to add to the front panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type" 				=> "icons_panel",
				'heading' 			=> __( 'Front Panel: Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 		=> 'front_icon_font',
				'value'				=> '',
				"settings" 			=> array(
					"emptyIcon" 			=> false,
					'emptyIconValue'		=> 'transparent',
					"type" 					=> 'extensions',
				),
				"admin_label"       => true,
				"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon for the front panel.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        => array( 'element' => "front_icon_type", 'value' => 'icon' ),
				"group" 			=> "Front Panel",
			),			
			array(
				"type"              => "attach_image",
				"heading"           => __( "Front Panel: Select Image", "ts_visual_composer_extend" ),
				"param_name"        => "front_icon_image",
				"value"             => "",
				"description"       => __( "The image should have equal dimensions for scaling purposes (i.e. 100x100)", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_type", 'value' => 'image' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Front Panel: Icon Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "front_icon_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the front panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_type", 'value' => array('icon', 'image') ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Front Panel: Icon / Image Size", "ts_visual_composer_extend" ),
				"param_name"        => "front_icon_size",
				"value"             => "70",
				"min"               => "16",
				"max"               => "512",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the icon / image size for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Front Panel: Icon / Image Padding", "ts_visual_composer_extend"),
				"param_name"		=> "front_icon_padding",
				"style_type"		=> "padding",
				"label_width"		=> "",
				"default_positions"	=> array(
					//"All"						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Top"						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Right"						=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Bottom"					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Left"						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
				),
				"value"				=> "padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;",
				"description"		=> __( "Define the internal padding sizes for the front panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Front Panel: Icon / Image Border", "ts_visual_composer_extend"),
				"param_name"		=> "front_icon_border",
				"style_type"		=> "border",
				"show_main"			=> "false",
				"show_preview"		=> "false",
				"show_width"		=> "true",
				"show_style"		=> "true",
				"show_radius"		=> "true",					
				"show_color"		=> "true",
				"show_unit_width"	=> "true",
				"show_unit_radius"	=> "true",
				"override_all"		=> "false",
				"default_positions"	=> array(
					"All"						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"						=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"		=> __( "Define the border you want to add to the front panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Icon Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_icon_color",
				"value"             => "#cccccc",
				"description"       => __( "Define the color of the front panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_icon_replace", 'value' => 'false' ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "front_icon_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Icon / Image Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_icon_background",
				"value"             => "",
				"description"       => __( "Define the background color for the front panel icon / transparent image.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "front_icon_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),			
			// Front Title Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2_3",
				"seperator"			=> "Front Title",
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "textarea_raw_html",
				"heading"           => __( "Front Panel: Title", "ts_visual_composer_extend" ),
				"param_name"        => "front_title_string",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the title for the front panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Front Panel: Title Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "front_title_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the front panel title.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Front Panel: Title Wrap", "ts_visual_composer_extend" ),
				"param_name"        => "front_title_wrapper",
				"width"             => 300,
				"value"             => array(
					__( 'H1', "ts_visual_composer_extend" )       				=> "h1",
					__( 'H2', "ts_visual_composer_extend" )    					=> "h2",
					__( 'H3', "ts_visual_composer_extend" )         			=> "h3",
					__( 'H4', "ts_visual_composer_extend" )         			=> "h4",
					__( 'H5', "ts_visual_composer_extend" )    					=> "h5",
					__( 'H6', "ts_visual_composer_extend" )    					=> "h6",
					__( 'DIV', "ts_visual_composer_extend" )    				=> "div",
				),
				"std"				=> "h3",
				"default"			=> "h3",
				"description"       => __( "Select what type should be used to wrap the front title.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "front_title_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Title Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_title_color",
				"value"             => "#000000",
				"description"       => __( "Define the title color for the front panel.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "front_title_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "fontsmanager",
				"heading"			=> __( "Front Panel: Title Font", "ts_visual_composer_extend" ),
				"param_name"		=> "font_fronttitle_family",
				"value"				=> "",
				"default"			=> "true",
				"connector"			=> "font_fronttitle_type",
				"description"		=> __( "Select the font to be used for the front title text.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_title_customize", 'value' => 'true' ),
				"group"				=> "Front Panel",
			),
			array(
				"type"				=> "hidden_input",
				"param_name"		=> "font_fronttitle_type",
				"value"				=> "",
				"dependency"        => array( 'element' => "front_title_customize", 'value' => 'true' ),
				"group"				=> "Front Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Front Panel: Title Size", "ts_visual_composer_extend" ),
				"param_name"        => "font_fronttitle_size",
				"value"             => "18",
				"min"               => "14",
				"max"               => "64",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Define the font size for the front panel title.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_title_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			// Front Panel Content
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2_4",
				"seperator"			=> "Front Content",
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           => __( "Front Panel: Content", "ts_visual_composer_extend" ),
				"param_name"        => "front_content_html",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the content for the front panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Front Panel: Content Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "front_content_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the front panel content.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "fontsmanager",
				"heading"			=> __( "Front Panel: Content Font", "ts_visual_composer_extend" ),
				"param_name"		=> "font_frontcontent_family",
				"value"				=> "",
				"default"			=> "true",
				"connector"			=> "font_frontcontent_type",
				"description"		=> __( "Select the font to be used for the front message text.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_content_customize", 'value' => 'true' ),
				"group"				=> "Front Panel",
			),
			array(
				"type"				=> "hidden_input",
				"param_name"		=> "font_frontcontent_type",
				"value"				=> "",
				"dependency"        => array( 'element' => "front_content_customize", 'value' => 'true' ),
				"group"				=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Font Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_content_color",
				"value"             => "#000000",
				"description"       => __( "Define the font color for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_content_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_panel_background",
				"value"             => "#ffffff",
				"description"       => __( "Define the background color for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_content_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Front Panel: Line Height", "ts_visual_composer_extend" ),
				"param_name"        => "front_panel_line",
				"value"             => "110",
				"min"               => "100",
				"max"               => "250",
				"step"              => "1",
				"unit"              => '%',
				"description"       => __( "Define the line height for the front panel content.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_content_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			// Front Panel Styling
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2_5",
				"seperator"			=> "Panel Styling",
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Front Panel: Other Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "front_panel_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some global aspects of the front panel styling.", "ts_visual_composer_extend" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Front Panel: Background Type", "ts_visual_composer_extend" ),
				"param_name"        => "front_panel_styling",
				"width"             => 300,
				"value"             => array(
					__( 'Single Color', "ts_visual_composer_extend" )       	=> "color",
					__( 'Gradient Color', "ts_visual_composer_extend" )			=> "gradient",
					__( 'Pattern Image', "ts_visual_composer_extend" )			=> "pattern",
				),
				"description"       => __( "Select what type of background should be used for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_panel_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Front Panel: Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "front_panel_color",
				"value"             => "#ffffff",
				"description"       => __( "Define the background color to be used for the front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_panel_styling", 'value' => "color" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "advanced_gradient",
				"heading"			=> __("Front Panel: Gradient Background", "ts_visual_composer_extend"),						
				"param_name"		=> "front_panel_gradient",
				"description"		=> __('Use the controls above to create a custom gradient background for the front panel.', 'ts_visual_composer_extend'),
				"dependency"        => array( 'element' => "front_panel_styling", 'value' => "gradient" ),
				"group" 			=> "Front Panel",
			),			
			array(
				"type"              => "background",
				"heading"           => __( "Front Panel: Background Pattern", "ts_visual_composer_extend" ),
				"param_name"        => "front_panel_pattern",
				"height"            => 200,
				"pattern"           => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Background_List,
				"value"				=> "",
				"encoding"          => "false",
				"empty"				=> "true",
				"description"       => __( "Select the background pattern for front panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_panel_styling", 'value' => "pattern" ),
				"group" 			=> "Front Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Front Panel: Border", "ts_visual_composer_extend"),
				"param_name"		=> "front_panel_border",
				"style_type"		=> "border",
				"show_main"			=> "false",
				"show_preview"		=> "false",
				"show_width"		=> "true",
				"show_style"		=> "true",
				"show_radius"		=> "true",					
				"show_color"		=> "true",
				"show_unit_width"	=> "true",
				"show_unit_radius"	=> "true",
				"override_all"		=> "false",
				"default_positions"	=> array(
					"All"						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"						=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"		=> __( "Define the border you want to add to the front panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "front_panel_customize", 'value' => 'true' ),
				"group" 			=> "Front Panel",
			),
			// Back Banner Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3_1",
				"seperator"			=> "Back Banner",
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Back Panel: Use Banner", "ts_visual_composer_extend" ),
				"param_name"		=> "back_banner_use",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to add a banner image to the top of the back panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "attach_image",
				"heading"           => __( "Back Panel: Banner Image", "ts_visual_composer_extend" ),
				"param_name"        => "back_banner_image",
				"value"             => "",
				"description"       => __( "Select the image to be used as banner for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_banner_use", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			// Front Icon/Image Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3_2",
				"seperator"			=> "Back Icon",
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Back Panel: Icon Type", "ts_visual_composer_extend" ),
				"param_name"        => "back_icon_type",
				"width"             => 300,
				"value"             => array(
					__( 'None', "ts_visual_composer_extend" )       					=> "none",
					__( 'Font Icon', "ts_visual_composer_extend" )       				=> "icon",
					__( 'Image Icon', "ts_visual_composer_extend" )    					=> "image",
				),
				"description"       => __( "Select the type of icon or image you want to add to the back panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type" 				=> "icons_panel",
				'heading' 			=> __( 'Back Panel: Select Icon', 'ts_visual_composer_extend' ),
				'param_name' 		=> 'back_icon_font',
				'value'				=> '',
				"settings" 			=> array(
					"emptyIcon" 			=> false,
					'emptyIconValue'		=> 'transparent',
					"type" 					=> 'extensions',
				),
				"admin_label"       => true,
				"description"       => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorVisualSelector == "true" ? __( "Select the icon for the back panel.", "ts_visual_composer_extend" ) : $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_IconSelectorString),
				"dependency"        => array( 'element' => "back_icon_type", 'value' => 'icon' ),
				"group" 			=> "Back Panel",
			),			
			array(
				"type"              => "attach_image",
				"heading"           => __( "Back Panel: Select Image", "ts_visual_composer_extend" ),
				"param_name"        => "back_icon_image",
				"value"             => "",
				"description"       => __( "The image should have equal dimensions for scaling purposes (i.e. 100x100)", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_icon_type", 'value' => 'image' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Back Panel: Icon Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "back_icon_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the back panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_icon_type", 'value' => array('icon', 'image') ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Back Panel: Icon / Image Size", "ts_visual_composer_extend" ),
				"param_name"        => "back_icon_size",
				"value"             => "70",
				"min"               => "16",
				"max"               => "512",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the icon / image size for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_icon_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Back Panel: Icon / Image Padding", "ts_visual_composer_extend"),
				"param_name"		=> "back_icon_padding",
				"style_type"		=> "padding",
				"label_width"		=> "",
				"default_positions"	=> array(
					//"All"							=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Top"							=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Right"							=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Bottom"						=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
					"Left"							=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "10", "unitwidth" => "px", "style" => "solid", "color" => "#000000", "radius" => "0", "unitradius" => "px"),
				),
				"value"				=> "padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;",
				"description"		=> __( "Define the internal padding sizes for the back panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_icon_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Back Panel: Icon / Image Border", "ts_visual_composer_extend"),
				"param_name"		=> "back_icon_border",
				"style_type"		=> "border",
				"show_main"			=> "false",
				"show_preview"		=> "false",
				"show_width"		=> "true",
				"show_style"		=> "true",
				"show_radius"		=> "true",					
				"show_color"		=> "true",
				"show_unit_width"	=> "true",
				"show_unit_radius"	=> "true",
				"override_all"		=> "false",
				"default_positions"	=> array(
					"All"						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"						=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"		=> __( "Define the border you want to add to the back panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_icon_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Icon Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_icon_color",
				"value"             => "#cccccc",
				"description"       => __( "Define the color of the back panel icon.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "back_icon_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Icon / Image Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_icon_background",
				"value"             => "",
				"description"       => __( "Define the background color for the back panel icon / transparent image.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "back_icon_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),			
			// Back Title Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3_3",
				"seperator"			=> "Back Title",
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "textarea_raw_html",
				"heading"           => __( "Back Panel: Title", "ts_visual_composer_extend" ),
				"param_name"        => "back_title_string",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the title for the back panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Back Panel: Title Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "back_title_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the back panel title.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Back Panel: Title Wrap", "ts_visual_composer_extend" ),
				"param_name"        => "back_title_wrapper",
				"width"             => 300,
				"value"             => array(
					__( 'H1', "ts_visual_composer_extend" )       				=> "h1",
					__( 'H2', "ts_visual_composer_extend" )    					=> "h2",
					__( 'H3', "ts_visual_composer_extend" )         			=> "h3",
					__( 'H4', "ts_visual_composer_extend" )         			=> "h4",
					__( 'H5', "ts_visual_composer_extend" )    					=> "h5",
					__( 'H6', "ts_visual_composer_extend" )    					=> "h6",
					__( 'DIV', "ts_visual_composer_extend" )    				=> "div",
				),
				"std"				=> "h3",
				"default"			=> "h3",
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"description"       => __( "Select what type should be used to wrap the back title.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_title_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Title Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_title_color",
				"value"             => "#000000",
				"description"       => __( "Define the title color for the back panel.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "back_title_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "fontsmanager",
				"heading"			=> __( "Back Panel: Title Font", "ts_visual_composer_extend" ),
				"param_name"		=> "font_backtitle_family",
				"value"				=> "",
				"default"			=> "true",
				"connector"			=> "font_backtitle_type",
				"description"		=> __( "Select the font to be used for the back title text.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_title_customize", 'value' => 'true' ),
				"group"				=> "Back Panel",
			),
			array(
				"type"				=> "hidden_input",
				"param_name"		=> "font_backtitle_type",
				"value"				=> "",
				"dependency"        => array( 'element' => "back_title_customize", 'value' => 'true' ),
				"group"				=> "Back Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Back Panel: Title Size", "ts_visual_composer_extend" ),
				"param_name"        => "font_backtitle_size",
				"value"             => "18",
				"min"               => "14",
				"max"               => "64",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Define the font size for the back panel title.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_title_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			// Back Panel Content
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3_4",
				"seperator"			=> "Back Content",
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           => __( "Back Panel: Content", "ts_visual_composer_extend" ),
				"param_name"        => "back_content_html",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the content for the back panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Back Panel: Content Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "back_content_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some aspects of the back panel content.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "fontsmanager",
				"heading"			=> __( "Back Panel: Content Font", "ts_visual_composer_extend" ),
				"param_name"		=> "font_backcontent_family",
				"value"				=> "",
				"default"			=> "true",
				"connector"			=> "font_backcontent_type",
				"description"		=> __( "Select the font to be used for the back message text.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_content_customize", 'value' => 'true' ),
				"group"				=> "Back Panel",
			),
			array(
				"type"				=> "hidden_input",
				"param_name"		=> "font_backcontent_type",
				"value"				=> "",
				"dependency"        => array( 'element' => "back_content_customize", 'value' => 'true' ),
				"group"				=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Font Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_content_color",
				"value"             => "#000000",
				"description"       => __( "Define the font color for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_content_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_panel_background",
				"value"             => "#ffffff",
				"description"       => __( "Define the background color for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_content_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Back Panel: Line Height", "ts_visual_composer_extend" ),
				"param_name"        => "back_panel_line",
				"value"             => "110",
				"min"               => "100",
				"max"               => "250",
				"step"              => "1",
				"unit"              => '%',
				"description"       => __( "Define the line height for the back panel content.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_content_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			// Back Panel Styling
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3_5",
				"seperator"			=> "Panel Styling",
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Back Panel: Other Customizations", "ts_visual_composer_extend" ),
				"param_name"		=> "back_panel_customize",
				"value"				=> "false",
				"description"		=> __( "Use the toggle if you want to customize some global aspects of the back panel styling.", "ts_visual_composer_extend" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Back Panel: Background Type", "ts_visual_composer_extend" ),
				"param_name"        => "back_panel_styling",
				"width"             => 300,
				"value"             => array(
					__( 'Single Color', "ts_visual_composer_extend" )       	=> "color",
					__( 'Gradient Color', "ts_visual_composer_extend" )			=> "gradient",
					__( 'Pattern Image', "ts_visual_composer_extend" )			=> "pattern",
				),
				"description"       => __( "Select what type of background should be used for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_panel_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Back Panel: Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "back_panel_color",
				"value"             => "#ffffff",
				"description"       => __( "Define the background color to be used for the back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_panel_styling", 'value' => "color" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "advanced_gradient",
				"heading"			=> __("Back Panel: Gradient Background", "ts_visual_composer_extend"),						
				"param_name"		=> "back_panel_gradient",
				"description"		=> __('Use the controls above to create a custom gradient background for the back panel.', 'ts_visual_composer_extend'),
				"dependency"        => array( 'element' => "back_panel_styling", 'value' => "gradient" ),
				"group" 			=> "Back Panel",
			),			
			array(
				"type"              => "background",
				"heading"           => __( "Back Panel: Background Pattern", "ts_visual_composer_extend" ),
				"param_name"        => "back_panel_pattern",
				"height"            => 200,
				"pattern"           => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_Background_List,
				"value"				=> "",
				"encoding"          => "false",
				"empty"				=> "true",
				"description"       => __( "Select the background pattern for back panel.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_panel_styling", 'value' => "pattern" ),
				"group" 			=> "Back Panel",
			),
			array(
				"type"				=> "advanced_styling",
				"heading"			=> __("Back Panel: Border", "ts_visual_composer_extend"),
				"param_name"		=> "back_panel_border",
				"style_type"		=> "border",
				"show_main"			=> "false",
				"show_preview"		=> "false",
				"show_width"		=> "true",
				"show_style"		=> "true",
				"show_radius"		=> "true",					
				"show_color"		=> "true",
				"show_unit_width"	=> "true",
				"show_unit_radius"	=> "true",
				"override_all"		=> "false",
				"default_positions"	=> array(
					"All"						=> array("string" => __("All", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Top"						=> array("string" => __("Top", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Right"						=> array("string" => __("Right", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Bottom"					=> array("string" => __("Bottom", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
					"Left"						=> array("string" => __("Left", "ts_visual_composer_extend"),	"width" => "0", "unitwidth" => "px", "style" => "solid", "color" => "#cccccc", "radius" => "0", "unitradius" => "px"),
				),
				"description"		=> __( "Define the border you want to add to the back panel icon.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "back_panel_customize", 'value' => 'true' ),
				"group" 			=> "Back Panel",
			),
			// Link Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_4_1",
				"seperator"			=> "Link Settings",
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Link: Add Link", "ts_visual_composer_extend" ),
				"param_name"        => "link_usage",
				"value"             => "false",
				"description"       => __( "Switch the toggle if you want to add a link to the back panel.", "ts_visual_composer_extend" ),
				"group" 			=> "Link Settings",
			),
			array(
				"type" 				=> ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ParameterLinkPicker['enabled'] == "false" ? "vc_link" : "advancedlinks"),
				"heading" 			=> __("Link: Information", "ts_visual_composer_extend"),
				"param_name" 		=> "link_data",
				"description" 		=> __("Provide a link to another site/page for the panel button.", "ts_visual_composer_extend"),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Link: Effect", "ts_visual_composer_extend" ),
				"param_name"		=> "link_effect",
				"width"				=> 300,
				"value"				=> array(
					__( 'Effect', "ts_visual_composer_extend" ) . ' 1'		=> "effect-1",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 2'		=> "effect-2",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 3'		=> "effect-3",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 4'		=> "effect-4",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 5'		=> "effect-5",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 6'		=> "effect-6",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 7'		=> "effect-7",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 8'		=> "effect-8",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 9'		=> "effect-9",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 10'		=> "effect-10",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 11'		=> "effect-11",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 12'		=> "effect-12",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 13'		=> "effect-13",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 14'		=> "effect-14",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 15'		=> "effect-15",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 16'		=> "effect-16",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 17'		=> "effect-17",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 18'		=> "effect-18",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 19'		=> "effect-19",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 20'		=> "effect-20",
					__( 'Effect', "ts_visual_composer_extend" ) . ' 21'		=> "effect-21",
				),
				"description"		=> __( "Select the effect style for the link", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "textfield",
				"heading"			=> __( "Link: Text", "ts_visual_composer_extend" ),
				"param_name"		=> "link_content",
				"value"				=> "Link Text",
				"description"		=> __( "Enter the text string that should be used for the link; HTML code or shortcode can NOT be used.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "textfield",
				"heading"			=> __( "Link: Message", "ts_visual_composer_extend" ),
				"param_name"		=> "link_message",
				"value"				=> "Link Message",
				"description"		=> __( "Enter an optional VERY short message for the link; HTML code can NOT be used.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-9') ),
				"group"				=> "Link Settings",
			),		
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Link: Text Align", "ts_visual_composer_extend" ),
				"param_name"		=> "link_align",
				"width"				=> 300,
				"value"				=> array(
					__( 'Center', "ts_visual_composer_extend" )      	=> "center",
					__( 'Left', "ts_visual_composer_extend" )			=> "left",
					__( 'Right', "ts_visual_composer_extend" )  		=> "right",
				),
				"description"		=> __( "Select how the text for the link should be aligned.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),			
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Link: Uppercase", "ts_visual_composer_extend" ),
				"param_name"		=> "link_uppercase",
				"value"				=> "true",
				"description"		=> __( "Switch the toggle if you want to transform all link text characters to uppercase.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),			
			array(
				"type"				=> "fontsmanager",
				"heading"			=> __( "Link: Font Family", "ts_visual_composer_extend" ),
				"param_name"		=> "link_font_family",
				"value"				=> "",
				"default"			=> "true",
				"connector"			=> "link_font_type",
				"description"		=> __( "Select the font to be used for the title text.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "hidden_input",
				"param_name"		=> "link_font_type",
				"value"				=> "",
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),				
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Text Standard Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_text_color",
				"value"				=> "#9a9a9a",
				"description"		=> __( "Define the standard color of the text for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Text Hover Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_text_hover",
				"value"				=> "#717171",
				"description"		=> __( "Define the hover color of the text for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "link_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),				
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Message Standard Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_message_color",
				"value"				=> "#cccccc",
				"description"		=> __( "Define the standard color of the message for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-9') ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Message Hover Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_message_hover",
				"value"				=> "#cccccc",
				"description"		=> __( "Define the hover color of the message for the link.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"		=> array( 'element' => "link_effect", 'value' => array() ),
				"group" 			=> "Link Settings",
			),				
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Background Standard Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_back_color",
				"value"				=> "#001f3a",
				"description"		=> __( "Define the standard background color of the link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-2', 'effect-10', 'effect-19', 'effect-20') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group"				=> "Link Settings",
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Background Hover Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_back_hover",
				"value"				=> "#011425",
				"description"		=> __( "Define the hover background color of the link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-2', 'effect-10', 'effect-19', 'effect-20') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group"				=> "Link Settings",
			),				
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Link: Border Type", "ts_visual_composer_extend" ),
				"param_name"		=> "link_border_type",
				"width"				=> 300,
				"value"				=> array(						
					__( "Solid Border", "ts_visual_composer_extend" )                  => "solid",
					__( "Dotted Border", "ts_visual_composer_extend" )                 => "dotted",
					__( "Dashed Border", "ts_visual_composer_extend" )                 => "dashed",
					__( "Double Border", "ts_visual_composer_extend" )                 => "double",
					__( "Grouve Border", "ts_visual_composer_extend" )                 => "groove",
					__( "Ridge Border", "ts_visual_composer_extend" )                  => "ridge",
					__( "Inset Border", "ts_visual_composer_extend" )                  => "inset",
					__( "Outset Border", "ts_visual_composer_extend" )                 => "outset",
				),
				"description"		=> __( "Select the type of border for the creative link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-8', 'effect-11') ),
				"group"				=> "Link Settings",
			),
			array(
				"type"				=> "nouislider",
				"heading"			=> __( "Link: Border Width", "ts_visual_composer_extend" ),
				"param_name"		=> "link_border_width",
				"value"				=> "2",
				"min"				=> "1",
				"max"				=> "20",
				"step"				=> "1",
				"unit"				=> 'px',
				"description"		=> __( "Define the border width for the creative link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-6', 'effect-7', 'effect-8', 'effect-11') ),
				"group"				=> "Link Settings",
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Border Standard Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_border_color",
				"value"				=> "#cccccc",
				"description"		=> __( "Define the border standard color for the creative link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-3', 'effect-4', 'effect-6', 'effect-7', 'effect-8', 'effect-9', 'effect-12', 'effect-13', 'effect-14', 'effect-18', 'effect-20', 'effect-21') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group"				=> "Link Settings",
			),
			array(
				"type"				=> "colorpicker",
				"heading"			=> __( "Link: Border Hover Color", "ts_visual_composer_extend" ),
				"param_name"		=> "link_border_hover",
				"value"				=> "#ededed",
				"description"		=> __( "Define the border hover color for the creative link.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "link_effect", 'value' => array('effect-8') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group"				=> "Link Settings",
			),
			// Link Tooltip
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_4_2",
				"seperator"			=> "Link Tooltip",
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Link: Add Tooltip", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_usage",
				"value"             => "false",
				"description"       => __( "Switch the toggle if you want to add a tooltip to the link.", "ts_visual_composer_extend" ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"              => ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_EditorBase64TinyMCE == "true" ? "wysiwyg_base64" : "textarea_raw_html"),
				"heading"           => __( "Link: Tooltip", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_content",
				"minimal"			=> "true",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the content for the optional link tooltip.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_position",
				"value"				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Vertical,
				"description"		=> __( "Select the tooltip position in relation to the element.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),							
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_style",
				"value"             => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Styles,
				"description"		=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),			
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Tooltip Arrow", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_arrow",
				"value"             => "true",
				"description"       => __( "Switch the toggle to either show or hide the tooltip arrow.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Font Color", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_color",
				"value"             => "#ffffff",
				"description"       => __( "Define the custom font color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group" 			=> "Link Settings",
			),		
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Background Color", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_background",
				"value"             => "#000000",
				"description"       => __( "Define the custom background color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group" 			=> "Link Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Border Color", "ts_visual_composer_extend" ),
				"param_name"        => "tooltip_border",
				"value"             => "#000000",
				"description"       => __( "Define the custom border color for the tooltip.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_style", 'value' => array('tooltipster-custom', 'ts-simptip-style-custom') ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"group" 			=> "Link Settings",
			),	
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __( "Tooltip Animation", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_animation",
				"value"				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Animations,
				"description"		=> __( "Select how the tooltip entry and exit should be animated once triggered.", "ts_visual_composer_extend" ),
				"edit_field_class"	=> "vc_col-sm-6 vc_column",
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),	
			array(
				"type"				=> "nouislider",
				"heading"			=> __( "Tooltip X-Offset", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_offsetx",
				"value"				=> "0",
				"min"				=> "-100",
				"max"				=> "100",
				"step"				=> "1",
				"unit"				=> 'px',
				"description"		=> __( "Define an optional X-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			array(
				"type"				=> "nouislider",
				"heading"			=> __( "Tooltip Y-Offset", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_offsety",
				"value"				=> "0",
				"min"				=> "-100",
				"max"				=> "100",
				"step"				=> "1",
				"unit"				=> 'px',
				"description"		=> __( "Define an optional Y-Offset for the tooltip position.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "tooltip_usage", 'value' => 'true' ),
				"group" 			=> "Link Settings",
			),
			// Animation Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_5_1",
				"seperator"			=> "Animation Settings",
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "css3animations",
				"heading"			=> __("Animation: Front Icon/Image", "ts_visual_composer_extend"),
				"param_name"		=> "animation_fronticon",
				"prefix"			=> "ts-infinite-css-",
				"connector"			=> "animation_frontname",
				"noneselect"		=> "true",
				"default"			=> "",
				"value"				=> "",
				"description"		=> __("Select the animation for the front panel icon/image.", "ts_visual_composer_extend"),
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "hidden_input",
				"heading"			=> __( "Animation: Front Icon/Image", "ts_visual_composer_extend" ),
				"param_name"		=> "animation_frontname",
				"value"				=> "",
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "css3animations",
				"heading"			=> __("Animation: Back Icon/Image", "ts_visual_composer_extend"),
				"param_name"		=> "animation_backicon",
				"prefix"			=> "ts-infinite-css-",
				"connector"			=> "animation_backname",
				"noneselect"		=> "true",
				"default"			=> "",
				"value"				=> "",
				"description"		=> __("Select the animation for the back panel icon/image.", "ts_visual_composer_extend"),
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "hidden_input",
				"heading"			=> __( "Animation: Back Icon/Image", "ts_visual_composer_extend" ),
				"param_name"		=> "animation_backname",
				"value"				=> "",
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "css3animations",
				"heading"			=> __("Animation: Viewport", "ts_visual_composer_extend"),
				"param_name"		=> "viewport_class",
				"prefix"			=> "ts-viewport-css-",
				"connector"			=> "viewport_name",
				"noneselect"		=> "true",
				"default"			=> "",
				"value"				=> "",
				"description"		=> __("Select the viewport animation for the element.", "ts_visual_composer_extend"),
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "hidden_input",
				"heading"			=> __( "Animation: Viewport", "ts_visual_composer_extend" ),
				"param_name"		=> "viewport_name",
				"value"				=> "",
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "nouislider",
				"heading"			=> __( "Viewport Delay", "ts_visual_composer_extend" ),
				"param_name"		=> "viewport_delay",
				"value"				=> "0",
				"min"				=> "0",
				"max"				=> "20000",
				"step"				=> "100",
				"unit"				=> 'ms',
				"description"		=> __( "Define how long the CSS3 animation should be delayed after it has been triggered.", "ts_visual_composer_extend" ),
				"dependency"		=> array("element" => "viewport_class", "not_empty" => true),
				"group" 			=> "Other Settings",
			),
			array(
				"type" 				=> "viewport_offset",
				"heading" 			=> __( "Viewport Offset", "ts_visual_composer_extend"),
				"param_name" 		=> "viewport_offset",
				"value" 			=> '50%',
				"description" 		=> __("Define the offset (top of screen) that should trigger the viewport animation.", "ts_visual_composer_extend"),
				"dependency"		=> array("element" => "viewport_class", "not_empty" => true),
				"group" 			=> "Other Settings",
			),			
			array(
				"type"              => "nouislider",
				"heading"           => __( "Viewport Minimum", "ts_visual_composer_extend" ),
				"param_name"        => "viewport_limit",
				"value"             => "360",
				"min"               => "0",
				"max"               => "1024",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Define a minimum screen width that is required to show the viewport animation.", "ts_visual_composer_extend" ),
				"dependency"		=> array("element" => "viewport_class", "not_empty" => true),
				"group" 			=> "Other Settings",
			),
			// Other Conditionals
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_5_2",
				"seperator"			=> "Output Conditions",
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "ts_conditionals",
				"heading"			=> __( "Output Conditions", "ts_visual_composer_extend" ),
				"param_name"        => "conditionals",
				"group" 			=> "Other Settings",
			),
			// Other Flip Box Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_5_3",
				"seperator"			=> "Other Settings",
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"        => "margin_top",
				"value"             => "0",
				"min"               => "-50",
				"max"               => "200",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"        => "margin_bottom",
				"value"             => "0",
				"min"               => "-50",
				"max"               => "200",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "textfield",
				"heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"        => "el_id",
				"value"             => "",
				"description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "tag_editor",
				"heading"			=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"		=> "el_class",
				"value"				=> "",
				"description"		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group"				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>